<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
// use App\Models\PtwMstType;
use App\Repositories\Master\MasterUserAccessInterface;
use App\Http\Requests\Master\MasterUserAccessAddRequest;
use App\Http\Traits\InvalidTokenCheck;

class MasterUserAccessControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterUserAccessInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function userAccessList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listUserAccess($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function userAccessMasterList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->masterListUserAccess($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function userAccessAdd(MasterUserAccessAddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->userAccessAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function userAccessDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->userAccessDetails($request);
    }
}
