<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
// use App\Models\PtwMstType;
use App\Repositories\Master\MasterTypeTopicInterface;
use App\Http\Requests\Master\MasterTypeTopicAddRequest;
use App\Http\Traits\InvalidTokenCheck;

class MasterTypeTopicControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterTypeTopicInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function typeTopicList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->lisTypeTopic($request);
    }

    // /**
    //  * Store a newly created resource in storage.
    //  */
    // public function userAccessMasterList(Request $request)
    // {
    //     $creator = $this->getCreator($request); //fetch created_by by the token value
    //     $request->merge(["CREATED_BY" => $creator]);
        
    //     return $this->repository->masterListUserAccess($request);
    // }

    /**
     * Store a newly created resource in storage.
     */
    public function typeTopicAdd(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->typeTopicAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function typeTopicDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->typeTopicDetails($request);
    }
}
