<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Master\SkillAddRequest;
// use App\Models\PtwMstType;
use App\Repositories\Master\MasterSkillInterface;

use App\Http\Traits\InvalidTokenCheck;

class MasterSkillControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterSkillInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function skillList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listSkill($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function skillAdd(SkillAddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->skillAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function skillDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->skillDetails($request);
    }
}
