<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Master\SOPPolicyAddRequest;
// use App\Models\PtwMstType;
use App\Repositories\Master\MasterSOPPolicyInterface;

use App\Http\Traits\InvalidTokenCheck;

class MasterSOPPolicyControllerV1 extends Controller
{
    
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterSOPPolicyInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function sopPolicyList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listSOPPolicy($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function sopPolicyAdd(SOPPolicyAddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->sopPolicyAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function sopPolicyDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->sopPolicyDetails($request);
    }
}
