<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Master\RiskRelatedAddRequest;
use App\Repositories\Master\MasterRiskRelatedInterface;

use App\Http\Traits\InvalidTokenCheck;

class MasterRiskRelatedControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterRiskRelatedInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function riskRelatedList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listRiskRelated($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function riskRelatedAdd(RiskRelatedAddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->riskRelatedAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function riskRelatedDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->riskRelatedDetails($request);
    }
}
