<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Master\LocationAddRequest;
// use App\Models\PtwMstType;
use App\Repositories\Master\MasterLocationInterface;

use App\Http\Traits\InvalidTokenCheck;

class MasterLocationControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterLocationInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function locationList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listLocation($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function locationAdd(LocationAddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->locationAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function locationDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->locationDetails($request);
    }
}
