<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Master\ContractorAddRequest;
// use App\Models\PtwMstType;
use App\Repositories\Master\MasterContractorInterface;

use App\Http\Traits\InvalidTokenCheck;

class MasterContractorControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterContractorInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function contractorList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listContractor($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function contractorAdd(ContractorAddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->contractorAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function contractorDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->contractorDetails($request);
    }
}
