<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Master\ActivityAddRequest;
use App\Repositories\Master\MasterActivityInterface;

use App\Http\Traits\InvalidTokenCheck;

class MasterActivityControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(MasterActivityInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function activityList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listActivity($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function activityAdd(ActivityAddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->activityAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function activityDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->activityDetails($request);
    }
}
