<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\INSPECTION\InspectionMasterListInterface;
use App\Http\Traits\InvalidTokenCheck;

class InspectionMasterListControllerV1 extends Controller
{
    //
     use InvalidTokenCheck;
     private $repository;
     
     public function __construct(InspectionMasterListInterface $repository){
         $this->repository = $repository;
     }

      /**
     * Store a newly created resource in storage.
     */
    public function masterListInspection(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->masterListInspection($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function masterChekListInspection(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->masterChekListInspection($request);
    }
}
