<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\InspectionMstType;
use App\Repositories\INSPECTION\InspectionInterface;
use App\Http\Traits\InvalidTokenCheck;
use App\Http\Requests\INSPECTION\AddRequest;
use Illuminate\Support\Facades\File;

class InspectionControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(InspectionInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function inspectionList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listInspection($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function inspectionAdd(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->inspectionAdd($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function inspectionDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->inspectionDetails($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function inspectionActivityLog(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->inspectionActivityLog($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function inspectionDownloadableList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->inspectionDownloadableList($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function inspectionDetailsExport(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->inspectionDetailsExport($request);
    }

}
