<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\HIRA\HiraMasterListInterface;
use App\Http\Traits\InvalidTokenCheck;

class HiraMasterListControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;
    
    public function __construct(HiraMasterListInterface $repository){
        $this->repository = $repository;
    }

    /**
    * Store a newly created resource in storage.
    */
    public function masterListHira(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->masterListHira($request);
    }
}
