<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\HIRA\AddRequest;
use App\Repositories\HIRA\HiraInterface;
use App\Http\Traits\InvalidTokenCheck;

class HiraControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(HiraInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //code
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->listHira($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraDetails(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->hiraDetails($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraAdd(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->hiraAdd($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraAddInfo(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->hiraAddInfo($request);
    }

     /**
     * Store a newly created resource in storage.
     */
    public function hiraActivityLog(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->hiraActivityLog($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraDetailsExport(Request $request)
    {        
        return $this->repository->hiraDetailsExport($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraAddAcm(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->hiraAddAcm($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraDownloadableList(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->hiraDownloadableList($request);
    }
    public function hiraWiseLog(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->hiraWiseLog($request);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function hiraAddDeclarationM(AddRequest $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->hiraAddDeclarationM($request);
    }
}
