<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\File\FileInterface;
use App\Http\Traits\InvalidTokenCheck;
use Illuminate\Support\Facades\File;





class FileControllerV1 extends Controller
{
    use InvalidTokenCheck;
    private $repository;

    public function __construct(FileInterface $repository){
        $this->repository = $repository;
    }
    
    /**
     * Display a listing of the resource.
     */
    public function fileupload(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        return $this->repository->fileUpload($request);
    }
}
