<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Dashboard\DashboardInspectionInterface;
use App\Http\Traits\InvalidTokenCheck;


class DashboardInspectionControllerV1 extends Controller
{
    //
    use InvalidTokenCheck;
    private $repository;

    public function __construct(DashboardInspectionInterface $repository){
        $this->repository = $repository;
    }

    /**
     * Store a newly created resource in storage.
     */
    public function dashboardInspectionCounts(Request $request)
    {
        $creator = $this->getCreator($request); //fetch created_by by the token value
        $request->merge(["CREATED_BY" => $creator]);
        
        return $this->repository->dashboardInspectionCounts($request);
    }
}
