<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\SsoLoginToken;
use App\Http\Traits\EncDecService;

use App\Http\Resources\SiteResource;

class AuthControllerV1 extends Controller
{
    use EncDecService;

    public function login(Request $request){
        
        $rawRequest = $this->customDecrypt($request->X_KEY);
        if(isset($rawRequest -> TOKEN)){
            $emailResult = SsoLoginToken::where("TOKEN",$rawRequest -> TOKEN)->first();
            if( !$emailResult ){
                $output = [
                    'ResponseCode'  => config('constants.FAILURE_RESPONSE_STATUS_CODE'),
                    'Response' => 'The provided credentials are incorrect. Please provide correct email id.'
                ];
                $jsonOutput = $this->customEncrypt($output);
                return response()->json(["X_KEY" =>$jsonOutput]);
            }
            $rawRequest -> EMAIL = $emailResult->EMAIL;
        }
        
        if( gettype($rawRequest) == "object" ){
            $requestJSON = (object)$rawRequest;
            $requestArray = ['EMAIL' => $requestJSON -> EMAIL , 'PASSWORD' => ""];
        }else{
            $requestArray = $this->convertStringToJSON($rawRequest);
            $requestJSON = (object) ($requestArray);
        }

        $request->validate([$requestArray]);
 
        $user = User::where('EMAIL', $this->customEncrypt($requestJSON->EMAIL))->first();
        if (!$user) {
            $output = [
                'ResponseCode'  => config('constants.FAILURE_RESPONSE_STATUS_CODE'),
                'Response' => 'The provided credentials are incorrect. Please provide correct email id.'
            ];
            $jsonOutput = $this->customEncrypt($output);
            return response()->json(["X_KEY" =>$jsonOutput]);
        }
        
        $createToken = $user->createToken('api-token');
        $accessToken = $createToken->accessToken;        

        $responseData = [
                            'token' => $accessToken->token,
                            "data"  => [
                                        "USER"=>[
                                                    "USER_ID" => $user->ID,
                                                    "NAME" =>  ($user -> IS_INFO_REDUCTED == 0 ) ?
                                                                ($this->customDecrypt($user -> FIRST_NAME)." ".$this->customDecrypt($user -> LAST_NAME))
                                                                :"-"
                                        ],
                                        "USER_EMAIL" =>  $user -> EMAIL,
                                        "USER_ID" => $user -> ID,
                                        "ROLES" => $user -> roles,
                                        "SITES" => SiteResource::collection($user -> sites),
                                        "LOCATIONS" => $user -> locations,
                                        "X_API_KEY" => Hash::make($accessToken->token)
                                        ]
                                    ];        
        $jsonData = ["ResponseCode" =>  config('constants.SUCCESS_RESPONSE_STATUS_CODE'),"Response"=>$responseData];
        $jsonOutput = $this->customEncrypt($jsonData);
        
        // SSO TOKEN DELETE
        SsoLoginToken::where("EMAIL" , $user -> EMAIL)->delete();
        
        return response()->json(["X_KEY" =>$jsonOutput]);
    }
}
