<?php
use Illuminate\Support\Facades\Cache;

function pr($data)
{
  echo "<pre>";
  print_r($data);
  echo "</pre>";
}

function prd($data)
{
  echo "<pre>";
  print_r($data);
  echo "</pre>";
  die;
}


function errorResponse($message){
  return response()->json([
            'Message'=>$message,
            'Status'=>400,
            'Type'=>'Error'
        ]);
}
function successResponse($message) {
  return response()->json([
            'Message'=>$message,
            'Status'=>200,
            'Type'=>'Success'
        ]);
}

/**
   * DB query with binding values
   * $query : String | it is a query string with `?` letter
   * $bindings : Array | array of values for every `?` letter
   */
function getQueryWithBindings($query,$bindings){
    return vsprintf(str_replace('?', '%s', $query), collect($bindings)->map(function ($binding) {
        $binding = addslashes($binding);
        return is_numeric($binding) ? $binding : "'{$binding}'";
    })->toArray());
}

function showDate($date, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d";

  // Convert string date to Carbon instance if it's not already
  $carbonDate = is_string($date) ? Carbon\Carbon::parse($date) : $date;

  return $carbonDate->setTimezone($timeZone)->format($format);
}

function convertSlashDate($date, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d";

  // Parse the date string using the specified format
  $carbonDate = Carbon\Carbon::createFromFormat('d/m/Y', $date);

  // Set the timezone and format the date
  return $carbonDate->setTimezone($timeZone)->format($format);

}

function currentDateTime($format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d H:i:s";
  return showDate(date($format),$format,$timeZone);
}

function currentDateTimeAddSubtract1($interval,$format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d H:i:s";
  $date = new DateTime(showDate(date($format), $format, $timeZone));
  $date->modify($interval);
  return showDate(date($format),$format,$timeZone);
}

function currentDateTimeAddSubtract($interval, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d H:i:s";
  
  // Create a Carbon instance representing the current date and time
  $carbonDate = Carbon\Carbon::now($timeZone);

  // Modify the date by adding or subtracting the given interval
  $carbonDate->modify($interval);

  // Return the modified date in the specified format and timezone
  return showDate($carbonDate, $format, $timeZone);
}

function createSlashDate($date, $format = null, $timeZone = null) {
  $timeZone = $timeZone ?? config("constants.APP_TIMEZONE");
  $format = $format ?? "Y-m-d";
  $datearr = explode(" ", $date);

  // Parse the date string using the specified format
  $carbonDate = Carbon\Carbon::createFromFormat('Y-m-d H:i:s', Carbon\Carbon::parse($datearr[0])->format('Y-m-d') . " " . $datearr[1]);

  // Set the timezone and format the date
  return $carbonDate->setTimezone($timeZone)->format($format);

}

function objectFilter($object){
  foreach ($object as $key => $value) {
    // Check if the value is empty
    if (($value) == "") {
        // Remove the property from the object
        unset($object->$key);
    }
  }
  return $object;
}

function getPrecautionActionList(){
  $preType = array();
  $preType[] = array('KEY'=>1, 'VALUE'=>'Tagged');
  $preType[] = array('KEY'=>2, 'VALUE'=>'Locked');
  //$preType[] = array('KEY'=>3, 'VALUE'=>'Removed');
  //$preType[] = array('KEY'=>4, 'VALUE'=>'Unlocked');
  return $preType;
}


function typeIdTextMapping(){
  return [
      1=>"CP",
      2=>"HW",
      3=>"WAH",
      4=>"EW"
  ];
}
function ordinalConversion($number) {
  $suffix = ['th', 'st', 'nd', 'rd', 'th', 'th', 'th', 'th', 'th', 'th'];
  if (($number % 100) >= 11 && ($number % 100) <= 13) {
      return $number . 'th';
  } else {
      return $number . $suffix[$number % 10];
  }
}

function getSeverityLikehoodColor($severity,$likelihood){
  $severityText=strtoupper($severity).$likelihood;
  $colour="";
  if($severityText=="A1" || $severityText=="A2" || $severityText=="B1"){
    $colour="#ff0a00";
  }
  if($severityText=="A3" || $severityText=="B2" || $severityText=="C1"){
    $colour="#ffff00";
  }
  if($severityText=="B3" || $severityText=="C2" || $severityText=="C3"){
    $colour="#92d050";
  }
   return $colour;
}

function getSeverityLikehoodStage($severity,$likelihood){
  $severityText=strtoupper($severity).$likelihood;
  $stage="Low";
  if($severityText=="A1" || $severityText=="A2" || $severityText=="B1"){
    $stage="High";
  }
  if($severityText=="A3" || $severityText=="B2" || $severityText=="C1"){
    $stage="Medium";
  }
  if($severityText=="B3" || $severityText=="C2" || $severityText=="C3"){
    $stage="Low";
  }
   return $stage;
}

function getSeverityLikehoodOrderBy($severity,$likelihood){
  $severityText=strtoupper($severity).$likelihood;
  $stage=3;
  if($severityText=="A1" || $severityText=="A2" || $severityText=="B1"){
    $stage=1;
  }
  if($severityText=="A3" || $severityText=="B2" || $severityText=="C1"){
    $stage=2;
  }
  if($severityText=="B3" || $severityText=="C2" || $severityText=="C3"){
    $stage=3;
  }
   return $stage;
}

function setTrainingcolor($sc_start_date,$sc_end_date,$status,$tr_start_date=null, $tr_end_date=null){
  $colour="vvs-vios-cal-scheduled";
  $date = date("Y-m-d");
  if($status==1){
    if(strtotime($sc_end_date) < strtotime($date)){
      $colour="vvs-vios-cal-over-due";
    }else{
      $colour="vvs-vios-cal-scheduled";
    }
  }
  if($status==2){
    if((strtotime($sc_start_date) <= strtotime($tr_end_date)) && (strtotime($sc_end_date) >= strtotime($tr_end_date))){
      $colour="vvs-vios-cal-completed";
    }else if((strtotime($sc_end_date) < strtotime($tr_end_date))){
      $colour="vvs-vios-cal-completed-over-due";
    }
  }
  /*if((!isset($tr_start_date) || $tr_start_date=='') && (!isset($tr_end_date) || $tr_end_date=='')){
    if((isset($sc_start_date) && $sc_start_date!='') && (isset($sc_end_date) && $sc_end_date!='')){
      //$sc_end = date("Y-m-d",strtotime($sc_end_date));
      if($status!=2){
        if(strtotime($sc_end_date) < strtotime($date)){
          $colour="vvs-vios-cal-completed-over-due";
        }else{
          $colour="vvs-vios-cal-over-due";
        }
      }
    }
  }elseif((isset($tr_start_date) && $tr_start_date!='') && (isset($tr_end_date) && $tr_end_date!='')){
    if((isset($sc_start_date) && $sc_start_date!='') && (isset($sc_end_date) && $sc_end_date!='')){
      if($status==2){
        if((strtotime($sc_start_date) < strtotime($tr_end_date)) &&
           (strtotime($sc_end_date) > strtotime($tr_end_date))){
          $colour="vvs-vios-cal-completed";
        }else{
          $colour="vvs-vios-cal-over-due-start";
        }
      }
    }
  }*/
  return $colour;
}

function getTrainingYearList(){
  $yearlist = array();
  for ($i=(date("Y")+1); $i >= 2020 ; $i--) {
    $yearlist[] = array('KEY'=>$i, 'VALUE'=>$i);
  }
  return $yearlist;
}

function getTrainingStatusList(){
  $tstatus = array();
  $tstatus[] = array('KEY'=>1, 'VALUE'=>'Planned');
  $tstatus[] = array('KEY'=>2, 'VALUE'=>'Un-planned');
  return $tstatus;
}

function getTrainingMonthList(){
  $monthlist = array();
  $monthlist[] = array('KEY'=>13, 'VALUE'=>'ALL');
  for ($i=1; $i <= 12 ; $i++) {
    $monthlist[] = array('KEY'=>$i, 'VALUE'=>date("F",mktime(0,0,0,$i,1,2000)));
  }
  return $monthlist;
}

function getTrainingMonthNumber($year){
  $monthlist["JAN"] = array('MONTH_NUM'=>"01", 'START_DATE'=>$year."-01-01");
  $monthlist["FEB"] = array('MONTH_NUM'=>"02", 'START_DATE'=>$year."-02-01");
  $monthlist["MAR"] = array('MONTH_NUM'=>"03", 'START_DATE'=>$year."-03-01");
  $monthlist["APR"] = array('MONTH_NUM'=>"04", 'START_DATE'=>$year."-04-01");
  $monthlist["MAY"] = array('MONTH_NUM'=>"05", 'START_DATE'=>$year."-05-01");
  $monthlist["JUN"] = array('MONTH_NUM'=>"06", 'START_DATE'=>$year."-06-01");
  $monthlist["JUL"] = array('MONTH_NUM'=>"07", 'START_DATE'=>$year."-07-01");
  $monthlist["AUG"] = array('MONTH_NUM'=>"08", 'START_DATE'=>$year."-08-01");
  $monthlist["SEP"] = array('MONTH_NUM'=>"09", 'START_DATE'=>$year."-09-01");
  $monthlist["OCT"] = array('MONTH_NUM'=>"10", 'START_DATE'=>$year."-10-01");
  $monthlist["NOV"] = array('MONTH_NUM'=>"11", 'START_DATE'=>$year."-11-01");
  $monthlist["DEC"] = array('MONTH_NUM'=>"12", 'START_DATE'=>$year."-12-01");
  return $monthlist;
}